package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait NotebookOutputOption {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption
}
object NotebookOutputOption {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption
  ): zio.aws.sagemaker.model.NotebookOutputOption = value match {
    case software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.ALLOWED =>
      val r = Allowed
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookOutputOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption =
      software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.UNKNOWN_TO_SDK_VERSION
  }
  case object Allowed extends zio.aws.sagemaker.model.NotebookOutputOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption =
      software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.ALLOWED
  }
  case object Disabled extends zio.aws.sagemaker.model.NotebookOutputOption {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption =
      software.amazon.awssdk.services.sagemaker.model.NotebookOutputOption.DISABLED
  }
}
