package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectiveStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus
}
object ObjectiveStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus
  ): zio.aws.sagemaker.model.ObjectiveStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ObjectiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus =
      software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Succeeded extends zio.aws.sagemaker.model.ObjectiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus =
      software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.SUCCEEDED
  }
  case object Pending extends zio.aws.sagemaker.model.ObjectiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus =
      software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.PENDING
  }
  case object Failed extends zio.aws.sagemaker.model.ObjectiveStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus =
      software.amazon.awssdk.services.sagemaker.model.ObjectiveStatus.FAILED
  }
}
