package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait OfflineStoreStatusValue {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue
}
object OfflineStoreStatusValue {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue
  ): zio.aws.sagemaker.model.OfflineStoreStatusValue = value match {
    case software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.BLOCKED =>
      val r = Blocked
      r
    case software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.OfflineStoreStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue =
      software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.sagemaker.model.OfflineStoreStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue =
      software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.ACTIVE
  }
  case object Blocked extends zio.aws.sagemaker.model.OfflineStoreStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue =
      software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.BLOCKED
  }
  case object Disabled extends zio.aws.sagemaker.model.OfflineStoreStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue =
      software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue.DISABLED
  }
}
