package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait OrderKey {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.OrderKey
}
object OrderKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.OrderKey
  ): zio.aws.sagemaker.model.OrderKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.OrderKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.OrderKey.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.OrderKey.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.OrderKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OrderKey =
      software.amazon.awssdk.services.sagemaker.model.OrderKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.OrderKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OrderKey =
      software.amazon.awssdk.services.sagemaker.model.OrderKey.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.OrderKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.OrderKey =
      software.amazon.awssdk.services.sagemaker.model.OrderKey.DESCENDING
  }
}
