package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName
import scala.jdk.CollectionConverters.*
final case class ParentHyperParameterTuningJob(
    hyperParameterTuningJobName: Optional[HyperParameterTuningJobName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob = {
    import ParentHyperParameterTuningJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob
      .builder()
      .optionallyWith(
        hyperParameterTuningJobName.map(value =>
          HyperParameterTuningJobName.unwrap(value): java.lang.String
        )
      )(_.hyperParameterTuningJobName)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly =
    zio.aws.sagemaker.model.ParentHyperParameterTuningJob.wrap(buildAwsValue())
}
object ParentHyperParameterTuningJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ParentHyperParameterTuningJob =
      zio.aws.sagemaker.model.ParentHyperParameterTuningJob(
        hyperParameterTuningJobName.map(value => value)
      )
    def hyperParameterTuningJobName: Optional[HyperParameterTuningJobName]
    def getHyperParameterTuningJobName
        : ZIO[Any, AwsError, HyperParameterTuningJobName] =
      AwsError.unwrapOptionField(
        "hyperParameterTuningJobName",
        hyperParameterTuningJobName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob
  ) extends zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly {
    override val hyperParameterTuningJobName
        : Optional[HyperParameterTuningJobName] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningJobName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ParentHyperParameterTuningJob
  ): zio.aws.sagemaker.model.ParentHyperParameterTuningJob.ReadOnly =
    new Wrapper(impl)
}
