package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait PipelineExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus
}
object PipelineExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus
  ): zio.aws.sagemaker.model.PipelineExecutionStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.EXECUTING =>
      val r = Executing
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Executing
      extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.EXECUTING
  }
  case object Stopping extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.STOPPED
  }
  case object Failed extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.FAILED
  }
  case object Succeeded
      extends zio.aws.sagemaker.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStatus.SUCCEEDED
  }
}
