package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  PipelineExecutionName,
  Timestamp,
  String3072,
  PipelineExecutionArn,
  PipelineExecutionDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PipelineExecutionSummary(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    pipelineExecutionStatus: Optional[
      zio.aws.sagemaker.model.PipelineExecutionStatus
    ] = Optional.Absent,
    pipelineExecutionDescription: Optional[PipelineExecutionDescription] =
      Optional.Absent,
    pipelineExecutionDisplayName: Optional[PipelineExecutionName] =
      Optional.Absent,
    pipelineExecutionFailureReason: Optional[String3072] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary = {
    import PipelineExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(pipelineExecutionStatus.map(value => value.unwrap))(
        _.pipelineExecutionStatus
      )
      .optionallyWith(
        pipelineExecutionDescription.map(value =>
          PipelineExecutionDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDescription)
      .optionallyWith(
        pipelineExecutionDisplayName.map(value =>
          PipelineExecutionName.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionDisplayName)
      .optionallyWith(
        pipelineExecutionFailureReason.map(value =>
          String3072.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionFailureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecutionSummary.wrap(buildAwsValue())
}
object PipelineExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecutionSummary =
      zio.aws.sagemaker.model.PipelineExecutionSummary(
        pipelineExecutionArn.map(value => value),
        startTime.map(value => value),
        pipelineExecutionStatus.map(value => value),
        pipelineExecutionDescription.map(value => value),
        pipelineExecutionDisplayName.map(value => value),
        pipelineExecutionFailureReason.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def startTime: Optional[Timestamp]
    def pipelineExecutionStatus
        : Optional[zio.aws.sagemaker.model.PipelineExecutionStatus]
    def pipelineExecutionDescription: Optional[PipelineExecutionDescription]
    def pipelineExecutionDisplayName: Optional[PipelineExecutionName]
    def pipelineExecutionFailureReason: Optional[String3072]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getPipelineExecutionStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.PipelineExecutionStatus] =
      AwsError.unwrapOptionField(
        "pipelineExecutionStatus",
        pipelineExecutionStatus
      )
    def getPipelineExecutionDescription
        : ZIO[Any, AwsError, PipelineExecutionDescription] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDescription",
        pipelineExecutionDescription
      )
    def getPipelineExecutionDisplayName
        : ZIO[Any, AwsError, PipelineExecutionName] =
      AwsError.unwrapOptionField(
        "pipelineExecutionDisplayName",
        pipelineExecutionDisplayName
      )
    def getPipelineExecutionFailureReason: ZIO[Any, AwsError, String3072] =
      AwsError.unwrapOptionField(
        "pipelineExecutionFailureReason",
        pipelineExecutionFailureReason
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary
  ) extends zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val pipelineExecutionStatus
        : Optional[zio.aws.sagemaker.model.PipelineExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionStatus())
        .map(value =>
          zio.aws.sagemaker.model.PipelineExecutionStatus.wrap(value)
        )
    override val pipelineExecutionDescription
        : Optional[PipelineExecutionDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineExecutionDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineExecutionDescription(value)
      )
    override val pipelineExecutionDisplayName: Optional[PipelineExecutionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionDisplayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionName(value)
        )
    override val pipelineExecutionFailureReason: Optional[String3072] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionFailureReason())
        .map(value => zio.aws.sagemaker.model.primitives.String3072(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary
  ): zio.aws.sagemaker.model.PipelineExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
