package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class PipelineExperimentConfig(
    experimentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialName: Optional[ExperimentEntityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExperimentConfig = {
    import PipelineExperimentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExperimentConfig
      .builder()
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly =
    zio.aws.sagemaker.model.PipelineExperimentConfig.wrap(buildAwsValue())
}
object PipelineExperimentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExperimentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExperimentConfig =
      zio.aws.sagemaker.model.PipelineExperimentConfig(
        experimentName.map(value => value),
        trialName.map(value => value)
      )
    def experimentName: Optional[ExperimentEntityName]
    def trialName: Optional[ExperimentEntityName]
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExperimentConfig
  ) extends zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly {
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExperimentConfig
  ): zio.aws.sagemaker.model.PipelineExperimentConfig.ReadOnly = new Wrapper(
    impl
  )
}
