package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ProcessingJobArn,
  ProcessingEnvironmentValue,
  Timestamp,
  FailureReason,
  ProcessingEnvironmentKey,
  TrainingJobArn,
  ExitMessage,
  MonitoringScheduleArn,
  ProcessingJobName,
  AutoMLJobArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ProcessingJob(
    processingInputs: Optional[
      Iterable[zio.aws.sagemaker.model.ProcessingInput]
    ] = Optional.Absent,
    processingOutputConfig: Optional[
      zio.aws.sagemaker.model.ProcessingOutputConfig
    ] = Optional.Absent,
    processingJobName: Optional[ProcessingJobName] = Optional.Absent,
    processingResources: Optional[zio.aws.sagemaker.model.ProcessingResources] =
      Optional.Absent,
    stoppingCondition: Optional[
      zio.aws.sagemaker.model.ProcessingStoppingCondition
    ] = Optional.Absent,
    appSpecification: Optional[zio.aws.sagemaker.model.AppSpecification] =
      Optional.Absent,
    environment: Optional[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = Optional.Absent,
    networkConfig: Optional[zio.aws.sagemaker.model.NetworkConfig] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    experimentConfig: Optional[zio.aws.sagemaker.model.ExperimentConfig] =
      Optional.Absent,
    processingJobArn: Optional[ProcessingJobArn] = Optional.Absent,
    processingJobStatus: Optional[zio.aws.sagemaker.model.ProcessingJobStatus] =
      Optional.Absent,
    exitMessage: Optional[ExitMessage] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    processingEndTime: Optional[Timestamp] = Optional.Absent,
    processingStartTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    monitoringScheduleArn: Optional[MonitoringScheduleArn] = Optional.Absent,
    autoMLJobArn: Optional[AutoMLJobArn] = Optional.Absent,
    trainingJobArn: Optional[TrainingJobArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingJob = {
    import ProcessingJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingJob
      .builder()
      .optionallyWith(
        processingInputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingInputs)
      .optionallyWith(
        processingOutputConfig.map(value => value.buildAwsValue())
      )(_.processingOutputConfig)
      .optionallyWith(
        processingJobName.map(value =>
          ProcessingJobName.unwrap(value): java.lang.String
        )
      )(_.processingJobName)
      .optionallyWith(processingResources.map(value => value.buildAwsValue()))(
        _.processingResources
      )
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(appSpecification.map(value => value.buildAwsValue()))(
        _.appSpecification
      )
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (ProcessingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(
        processingJobArn.map(value =>
          ProcessingJobArn.unwrap(value): java.lang.String
        )
      )(_.processingJobArn)
      .optionallyWith(processingJobStatus.map(value => value.unwrap))(
        _.processingJobStatus
      )
      .optionallyWith(
        exitMessage.map(value => ExitMessage.unwrap(value): java.lang.String)
      )(_.exitMessage)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        processingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingEndTime)
      .optionallyWith(
        processingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.processingStartTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        monitoringScheduleArn.map(value =>
          MonitoringScheduleArn.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(
        trainingJobArn.map(value =>
          TrainingJobArn.unwrap(value): java.lang.String
        )
      )(_.trainingJobArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingJob.ReadOnly =
    zio.aws.sagemaker.model.ProcessingJob.wrap(buildAwsValue())
}
object ProcessingJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingJob =
      zio.aws.sagemaker.model.ProcessingJob(
        processingInputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processingOutputConfig.map(value => value.asEditable),
        processingJobName.map(value => value),
        processingResources.map(value => value.asEditable),
        stoppingCondition.map(value => value.asEditable),
        appSpecification.map(value => value.asEditable),
        environment.map(value => value),
        networkConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        experimentConfig.map(value => value.asEditable),
        processingJobArn.map(value => value),
        processingJobStatus.map(value => value),
        exitMessage.map(value => value),
        failureReason.map(value => value),
        processingEndTime.map(value => value),
        processingStartTime.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        monitoringScheduleArn.map(value => value),
        autoMLJobArn.map(value => value),
        trainingJobArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def processingInputs
        : Optional[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]]
    def processingOutputConfig
        : Optional[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly]
    def processingJobName: Optional[ProcessingJobName]
    def processingResources
        : Optional[zio.aws.sagemaker.model.ProcessingResources.ReadOnly]
    def stoppingCondition
        : Optional[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly]
    def appSpecification
        : Optional[zio.aws.sagemaker.model.AppSpecification.ReadOnly]
    def environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def networkConfig: Optional[zio.aws.sagemaker.model.NetworkConfig.ReadOnly]
    def roleArn: Optional[RoleArn]
    def experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def processingJobArn: Optional[ProcessingJobArn]
    def processingJobStatus
        : Optional[zio.aws.sagemaker.model.ProcessingJobStatus]
    def exitMessage: Optional[ExitMessage]
    def failureReason: Optional[FailureReason]
    def processingEndTime: Optional[Timestamp]
    def processingStartTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def monitoringScheduleArn: Optional[MonitoringScheduleArn]
    def autoMLJobArn: Optional[AutoMLJobArn]
    def trainingJobArn: Optional[TrainingJobArn]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getProcessingInputs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProcessingInput.ReadOnly
    ]] = AwsError.unwrapOptionField("processingInputs", processingInputs)
    def getProcessingOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingOutputConfig",
      processingOutputConfig
    )
    def getProcessingJobName: ZIO[Any, AwsError, ProcessingJobName] =
      AwsError.unwrapOptionField("processingJobName", processingJobName)
    def getProcessingResources: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    ] = AwsError.unwrapOptionField("processingResources", processingResources)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getAppSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("appSpecification", appSpecification)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getNetworkConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getProcessingJobArn: ZIO[Any, AwsError, ProcessingJobArn] =
      AwsError.unwrapOptionField("processingJobArn", processingJobArn)
    def getProcessingJobStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingJobStatus] =
      AwsError.unwrapOptionField("processingJobStatus", processingJobStatus)
    def getExitMessage: ZIO[Any, AwsError, ExitMessage] =
      AwsError.unwrapOptionField("exitMessage", exitMessage)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getProcessingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingEndTime", processingEndTime)
    def getProcessingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("processingStartTime", processingStartTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getMonitoringScheduleArn: ZIO[Any, AwsError, MonitoringScheduleArn] =
      AwsError.unwrapOptionField("monitoringScheduleArn", monitoringScheduleArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getTrainingJobArn: ZIO[Any, AwsError, TrainingJobArn] =
      AwsError.unwrapOptionField("trainingJobArn", trainingJobArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ) extends zio.aws.sagemaker.model.ProcessingJob.ReadOnly {
    override val processingInputs
        : Optional[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingInputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ProcessingInput.wrap(item)
          }.toList
        )
    override val processingOutputConfig
        : Optional[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingOutputConfig.wrap(value)
        )
    override val processingJobName: Optional[ProcessingJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingJobName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProcessingJobName(value)
        )
    override val processingResources
        : Optional[zio.aws.sagemaker.model.ProcessingResources.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingResources())
        .map(value => zio.aws.sagemaker.model.ProcessingResources.wrap(value))
    override val stoppingCondition: Optional[
      zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingCondition())
      .map(value =>
        zio.aws.sagemaker.model.ProcessingStoppingCondition.wrap(value)
      )
    override val appSpecification
        : Optional[zio.aws.sagemaker.model.AppSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSpecification())
        .map(value => zio.aws.sagemaker.model.AppSpecification.wrap(value))
    override val environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
    override val networkConfig
        : Optional[zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfig())
        .map(value => zio.aws.sagemaker.model.NetworkConfig.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentConfig())
        .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val processingJobArn: Optional[ProcessingJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingJobArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProcessingJobArn(value)
        )
    override val processingJobStatus
        : Optional[zio.aws.sagemaker.model.ProcessingJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingJobStatus())
        .map(value => zio.aws.sagemaker.model.ProcessingJobStatus.wrap(value))
    override val exitMessage: Optional[ExitMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.exitMessage())
      .map(value => zio.aws.sagemaker.model.primitives.ExitMessage(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val processingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.processingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val processingStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingStartTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val monitoringScheduleArn: Optional[MonitoringScheduleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringScheduleArn(value)
        )
    override val autoMLJobArn: Optional[AutoMLJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val trainingJobArn: Optional[TrainingJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJobArn())
        .map(value => zio.aws.sagemaker.model.primitives.TrainingJobArn(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingJob
  ): zio.aws.sagemaker.model.ProcessingJob.ReadOnly = new Wrapper(impl)
}
