package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProcessingS3CompressionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType
}
object ProcessingS3CompressionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType
  ): zio.aws.sagemaker.model.ProcessingS3CompressionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.GZIP =>
      val r = Gzip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProcessingS3CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.ProcessingS3CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.NONE
  }
  case object Gzip extends zio.aws.sagemaker.model.ProcessingS3CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType.GZIP
  }
}
