package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProcessingS3InputMode {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode
}
object ProcessingS3InputMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode
  ): zio.aws.sagemaker.model.ProcessingS3InputMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.PIPE =>
      val r = Pipe
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.FILE =>
      val r = File
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProcessingS3InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Pipe extends zio.aws.sagemaker.model.ProcessingS3InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.PIPE
  }
  case object File extends zio.aws.sagemaker.model.ProcessingS3InputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode =
      software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode.FILE
  }
}
