package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ProcessingLocalPath, S3Uri}
import scala.jdk.CollectionConverters.*
final case class ProcessingS3Output(
    s3Uri: S3Uri,
    localPath: ProcessingLocalPath,
    s3UploadMode: zio.aws.sagemaker.model.ProcessingS3UploadMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output = {
    import ProcessingS3Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .localPath(ProcessingLocalPath.unwrap(localPath): java.lang.String)
      .s3UploadMode(s3UploadMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly =
    zio.aws.sagemaker.model.ProcessingS3Output.wrap(buildAwsValue())
}
object ProcessingS3Output {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingS3Output =
      zio.aws.sagemaker.model.ProcessingS3Output(s3Uri, localPath, s3UploadMode)
    def s3Uri: S3Uri
    def localPath: ProcessingLocalPath
    def s3UploadMode: zio.aws.sagemaker.model.ProcessingS3UploadMode
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getLocalPath: ZIO[Any, Nothing, ProcessingLocalPath] =
      ZIO.succeed(localPath)
    def getS3UploadMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingS3UploadMode] =
      ZIO.succeed(s3UploadMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output
  ) extends zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val localPath: ProcessingLocalPath =
      zio.aws.sagemaker.model.primitives.ProcessingLocalPath(impl.localPath())
    override val s3UploadMode: zio.aws.sagemaker.model.ProcessingS3UploadMode =
      zio.aws.sagemaker.model.ProcessingS3UploadMode.wrap(impl.s3UploadMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output
  ): zio.aws.sagemaker.model.ProcessingS3Output.ReadOnly = new Wrapper(impl)
}
