package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProfilingStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProfilingStatus
}
object ProfilingStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProfilingStatus
  ): zio.aws.sagemaker.model.ProfilingStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProfilingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProfilingStatus =
      software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.sagemaker.model.ProfilingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProfilingStatus =
      software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.ENABLED
  }
  case object Disabled extends zio.aws.sagemaker.model.ProfilingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProfilingStatus =
      software.amazon.awssdk.services.sagemaker.model.ProfilingStatus.DISABLED
  }
}
