package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ProjectStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProjectStatus
}
object ProjectStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProjectStatus
  ): zio.aws.sagemaker.model.ProjectStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_IN_PROGRESS =>
      val r = CreateInProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_COMPLETED =>
      val r = CreateCompleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_FAILED =>
      val r = CreateFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_IN_PROGRESS =>
      val r = DeleteInProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_COMPLETED =>
      val r = DeleteCompleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_IN_PROGRESS =>
      val r = UpdateInProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_COMPLETED =>
      val r = UpdateCompleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_FAILED =>
      val r = UpdateFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.PENDING
  }
  case object CreateInProgress extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_IN_PROGRESS
  }
  case object CreateCompleted extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_COMPLETED
  }
  case object CreateFailed extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.CREATE_FAILED
  }
  case object DeleteInProgress extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_IN_PROGRESS
  }
  case object DeleteFailed extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_FAILED
  }
  case object DeleteCompleted extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.DELETE_COMPLETED
  }
  case object UpdateInProgress extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_IN_PROGRESS
  }
  case object UpdateCompleted extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_COMPLETED
  }
  case object UpdateFailed extends zio.aws.sagemaker.model.ProjectStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProjectStatus =
      software.amazon.awssdk.services.sagemaker.model.ProjectStatus.UPDATE_FAILED
  }
}
