package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters.*
final case class RStudioServerProDomainSettings(
    domainExecutionRoleArn: RoleArn,
    rStudioConnectUrl: Optional[String] = Optional.Absent,
    rStudioPackageManagerUrl: Optional[String] = Optional.Absent,
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings = {
    import RStudioServerProDomainSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
      .builder()
      .domainExecutionRoleArn(
        RoleArn.unwrap(domainExecutionRoleArn): java.lang.String
      )
      .optionallyWith(rStudioConnectUrl.map(value => value: java.lang.String))(
        _.rStudioConnectUrl
      )
      .optionallyWith(
        rStudioPackageManagerUrl.map(value => value: java.lang.String)
      )(_.rStudioPackageManagerUrl)
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProDomainSettings.wrap(buildAwsValue())
}
object RStudioServerProDomainSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RStudioServerProDomainSettings =
      zio.aws.sagemaker.model.RStudioServerProDomainSettings(
        domainExecutionRoleArn,
        rStudioConnectUrl.map(value => value),
        rStudioPackageManagerUrl.map(value => value),
        defaultResourceSpec.map(value => value.asEditable)
      )
    def domainExecutionRoleArn: RoleArn
    def rStudioConnectUrl: Optional[String]
    def rStudioPackageManagerUrl: Optional[String]
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getDomainExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRoleArn)
    def getRStudioConnectUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rStudioConnectUrl", rStudioConnectUrl)
    def getRStudioPackageManagerUrl: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("rStudioPackageManagerUrl", rStudioPackageManagerUrl)
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ) extends zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly {
    override val domainExecutionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.domainExecutionRoleArn())
    override val rStudioConnectUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rStudioConnectUrl())
      .map(value => value: String)
    override val rStudioPackageManagerUrl: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rStudioPackageManagerUrl())
        .map(value => value: String)
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettings
  ): zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly =
    new Wrapper(impl)
}
