package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class RecommendationMetrics(
    costPerHour: Float,
    costPerInference: Float,
    maxInvocations: Integer,
    modelLatency: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics = {
    import RecommendationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
      .builder()
      .costPerHour(costPerHour: java.lang.Float)
      .costPerInference(costPerInference: java.lang.Float)
      .maxInvocations(maxInvocations: java.lang.Integer)
      .modelLatency(modelLatency: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly =
    zio.aws.sagemaker.model.RecommendationMetrics.wrap(buildAwsValue())
}
object RecommendationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationMetrics =
      zio.aws.sagemaker.model.RecommendationMetrics(
        costPerHour,
        costPerInference,
        maxInvocations,
        modelLatency
      )
    def costPerHour: Float
    def costPerInference: Float
    def maxInvocations: Integer
    def modelLatency: Integer
    def getCostPerHour: ZIO[Any, Nothing, Float] = ZIO.succeed(costPerHour)
    def getCostPerInference: ZIO[Any, Nothing, Float] =
      ZIO.succeed(costPerInference)
    def getMaxInvocations: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(maxInvocations)
    def getModelLatency: ZIO[Any, Nothing, Integer] = ZIO.succeed(modelLatency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ) extends zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly {
    override val costPerHour: Float = impl.costPerHour(): Float
    override val costPerInference: Float = impl.costPerInference(): Float
    override val maxInvocations: Integer = impl.maxInvocations(): Integer
    override val modelLatency: Integer = impl.modelLatency(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics
  ): zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly = new Wrapper(impl)
}
