package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RenderingError(code: String, message: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RenderingError = {
    import RenderingError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RenderingError
      .builder()
      .code(code: java.lang.String)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RenderingError.ReadOnly =
    zio.aws.sagemaker.model.RenderingError.wrap(buildAwsValue())
}
object RenderingError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RenderingError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RenderingError =
      zio.aws.sagemaker.model.RenderingError(code, message)
    def code: String
    def message: String
    def getCode: ZIO[Any, Nothing, String] = ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderingError
  ) extends zio.aws.sagemaker.model.RenderingError.ReadOnly {
    override val code: String = impl.code(): String
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RenderingError
  ): zio.aws.sagemaker.model.RenderingError.ReadOnly = new Wrapper(impl)
}
