package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolvedAttributes(
    autoMLJobObjective: Optional[zio.aws.sagemaker.model.AutoMLJobObjective] =
      Optional.Absent,
    problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      Optional.Absent,
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes = {
    import ResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
      .builder()
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.ResolvedAttributes.wrap(buildAwsValue())
}
object ResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResolvedAttributes =
      zio.aws.sagemaker.model.ResolvedAttributes(
        autoMLJobObjective.map(value => value.asEditable),
        problemType.map(value => value),
        completionCriteria.map(value => value.asEditable)
      )
    def autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def problemType: Optional[zio.aws.sagemaker.model.ProblemType]
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ) extends zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly {
    override val autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobObjective())
        .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResolvedAttributes
  ): zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly = new Wrapper(impl)
}
