package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.KeepAlivePeriodInSeconds
import scala.jdk.CollectionConverters.*
final case class ResourceConfigForUpdate(
    keepAlivePeriodInSeconds: KeepAlivePeriodInSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate = {
    import ResourceConfigForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate
      .builder()
      .keepAlivePeriodInSeconds(
        KeepAlivePeriodInSeconds.unwrap(keepAlivePeriodInSeconds): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly =
    zio.aws.sagemaker.model.ResourceConfigForUpdate.wrap(buildAwsValue())
}
object ResourceConfigForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceConfigForUpdate =
      zio.aws.sagemaker.model.ResourceConfigForUpdate(keepAlivePeriodInSeconds)
    def keepAlivePeriodInSeconds: KeepAlivePeriodInSeconds
    def getKeepAlivePeriodInSeconds
        : ZIO[Any, Nothing, KeepAlivePeriodInSeconds] =
      ZIO.succeed(keepAlivePeriodInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate
  ) extends zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly {
    override val keepAlivePeriodInSeconds: KeepAlivePeriodInSeconds =
      zio.aws.sagemaker.model.primitives
        .KeepAlivePeriodInSeconds(impl.keepAlivePeriodInSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfigForUpdate
  ): zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly = new Wrapper(
    impl
  )
}
