package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  IdempotencyToken,
  PipelineExecutionArn
}
import scala.jdk.CollectionConverters.*
final case class RetryPipelineExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn,
    clientRequestToken: IdempotencyToken,
    parallelismConfiguration: Optional[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest = {
    import RetryPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .clientRequestToken(
        IdempotencyToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RetryPipelineExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.RetryPipelineExecutionRequest.wrap(buildAwsValue())
}
object RetryPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RetryPipelineExecutionRequest =
      zio.aws.sagemaker.model.RetryPipelineExecutionRequest(
        pipelineExecutionArn,
        clientRequestToken,
        parallelismConfiguration.map(value => value.asEditable)
      )
    def pipelineExecutionArn: PipelineExecutionArn
    def clientRequestToken: IdempotencyToken
    def parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
    def getClientRequestToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(clientRequestToken)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest
  ) extends zio.aws.sagemaker.model.RetryPipelineExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
    override val clientRequestToken: IdempotencyToken =
      zio.aws.sagemaker.model.primitives
        .IdempotencyToken(impl.clientRequestToken())
    override val parallelismConfiguration
        : Optional[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest
  ): zio.aws.sagemaker.model.RetryPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
