package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduleStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ScheduleStatus
}
object ScheduleStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ScheduleStatus
  ): zio.aws.sagemaker.model.ScheduleStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.SCHEDULED =>
      val r = Scheduled
      r
    case software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ScheduleStatus =
      software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ScheduleStatus =
      software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.PENDING
  }
  case object Failed extends zio.aws.sagemaker.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ScheduleStatus =
      software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.FAILED
  }
  case object Scheduled extends zio.aws.sagemaker.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ScheduleStatus =
      software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.SCHEDULED
  }
  case object Stopped extends zio.aws.sagemaker.model.ScheduleStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ScheduleStatus =
      software.amazon.awssdk.services.sagemaker.model.ScheduleStatus.STOPPED
  }
}
