package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters.*
final case class SendPipelineExecutionStepSuccessResponse(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse = {
    import SendPipelineExecutionStepSuccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly =
    zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse
      .wrap(buildAwsValue())
}
object SendPipelineExecutionStepSuccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse =
      zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse(
        pipelineExecutionArn.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse
  ) extends zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse
  ): zio.aws.sagemaker.model.SendPipelineExecutionStepSuccessResponse.ReadOnly =
    new Wrapper(impl)
}
