package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class StartEdgeDeploymentStageRequest(
    edgeDeploymentPlanName: EntityName,
    stageName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest = {
    import StartEdgeDeploymentStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest
      .builder()
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartEdgeDeploymentStageRequest.ReadOnly =
    zio.aws.sagemaker.model.StartEdgeDeploymentStageRequest
      .wrap(buildAwsValue())
}
object StartEdgeDeploymentStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartEdgeDeploymentStageRequest =
      zio.aws.sagemaker.model
        .StartEdgeDeploymentStageRequest(edgeDeploymentPlanName, stageName)
    def edgeDeploymentPlanName: EntityName
    def stageName: EntityName
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest
  ) extends zio.aws.sagemaker.model.StartEdgeDeploymentStageRequest.ReadOnly {
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest
  ): zio.aws.sagemaker.model.StartEdgeDeploymentStageRequest.ReadOnly =
    new Wrapper(impl)
}
