package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  IdempotencyToken,
  PipelineExecutionArn
}
import scala.jdk.CollectionConverters.*
final case class StopPipelineExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn,
    clientRequestToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest = {
    import StopPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .clientRequestToken(
        IdempotencyToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StopPipelineExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.StopPipelineExecutionRequest.wrap(buildAwsValue())
}
object StopPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopPipelineExecutionRequest =
      zio.aws.sagemaker.model
        .StopPipelineExecutionRequest(pipelineExecutionArn, clientRequestToken)
    def pipelineExecutionArn: PipelineExecutionArn
    def clientRequestToken: IdempotencyToken
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
    def getClientRequestToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest
  ) extends zio.aws.sagemaker.model.StopPipelineExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
    override val clientRequestToken: IdempotencyToken =
      zio.aws.sagemaker.model.primitives
        .IdempotencyToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest
  ): zio.aws.sagemaker.model.StopPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
