package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProcessingJobName
import scala.jdk.CollectionConverters.*
final case class StopProcessingJobRequest(
    processingJobName: ProcessingJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest = {
    import StopProcessingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest
      .builder()
      .processingJobName(
        ProcessingJobName.unwrap(processingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopProcessingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopProcessingJobRequest.wrap(buildAwsValue())
}
object StopProcessingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopProcessingJobRequest =
      zio.aws.sagemaker.model.StopProcessingJobRequest(processingJobName)
    def processingJobName: ProcessingJobName
    def getProcessingJobName: ZIO[Any, Nothing, ProcessingJobName] =
      ZIO.succeed(processingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest
  ) extends zio.aws.sagemaker.model.StopProcessingJobRequest.ReadOnly {
    override val processingJobName: ProcessingJobName =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobName(impl.processingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest
  ): zio.aws.sagemaker.model.StopProcessingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
