package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{String200, WorkteamArn}
import scala.jdk.CollectionConverters.*
final case class SubscribedWorkteam(
    workteamArn: WorkteamArn,
    marketplaceTitle: Optional[String200] = Optional.Absent,
    sellerName: Optional[String] = Optional.Absent,
    marketplaceDescription: Optional[String200] = Optional.Absent,
    listingId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam = {
    import SubscribedWorkteam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .optionallyWith(
        marketplaceTitle.map(value => String200.unwrap(value): java.lang.String)
      )(_.marketplaceTitle)
      .optionallyWith(sellerName.map(value => value: java.lang.String))(
        _.sellerName
      )
      .optionallyWith(
        marketplaceDescription.map(value =>
          String200.unwrap(value): java.lang.String
        )
      )(_.marketplaceDescription)
      .optionallyWith(listingId.map(value => value: java.lang.String))(
        _.listingId
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly =
    zio.aws.sagemaker.model.SubscribedWorkteam.wrap(buildAwsValue())
}
object SubscribedWorkteam {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SubscribedWorkteam =
      zio.aws.sagemaker.model.SubscribedWorkteam(
        workteamArn,
        marketplaceTitle.map(value => value),
        sellerName.map(value => value),
        marketplaceDescription.map(value => value),
        listingId.map(value => value)
      )
    def workteamArn: WorkteamArn
    def marketplaceTitle: Optional[String200]
    def sellerName: Optional[String]
    def marketplaceDescription: Optional[String200]
    def listingId: Optional[String]
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getMarketplaceTitle: ZIO[Any, AwsError, String200] =
      AwsError.unwrapOptionField("marketplaceTitle", marketplaceTitle)
    def getSellerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sellerName", sellerName)
    def getMarketplaceDescription: ZIO[Any, AwsError, String200] = AwsError
      .unwrapOptionField("marketplaceDescription", marketplaceDescription)
    def getListingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("listingId", listingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam
  ) extends zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val marketplaceTitle: Optional[String200] = zio.aws.core.internal
      .optionalFromNullable(impl.marketplaceTitle())
      .map(value => zio.aws.sagemaker.model.primitives.String200(value))
    override val sellerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sellerName())
      .map(value => value: String)
    override val marketplaceDescription: Optional[String200] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketplaceDescription())
        .map(value => zio.aws.sagemaker.model.primitives.String200(value))
    override val listingId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.listingId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam
  ): zio.aws.sagemaker.model.SubscribedWorkteam.ReadOnly = new Wrapper(impl)
}
