package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters.*
final case class TimeSeriesForecastingSettings(
    status: Optional[zio.aws.sagemaker.model.FeatureStatus] = Optional.Absent,
    amazonForecastRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings = {
    import TimeSeriesForecastingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        amazonForecastRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.amazonForecastRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly =
    zio.aws.sagemaker.model.TimeSeriesForecastingSettings.wrap(buildAwsValue())
}
object TimeSeriesForecastingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TimeSeriesForecastingSettings =
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings(
        status.map(value => value),
        amazonForecastRoleArn.map(value => value)
      )
    def status: Optional[zio.aws.sagemaker.model.FeatureStatus]
    def amazonForecastRoleArn: Optional[RoleArn]
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAmazonForecastRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("amazonForecastRoleArn", amazonForecastRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings
  ) extends zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly {
    override val status: Optional[zio.aws.sagemaker.model.FeatureStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.FeatureStatus.wrap(value))
    override val amazonForecastRoleArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amazonForecastRoleArn())
        .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings
  ): zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly =
    new Wrapper(impl)
}
