package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrainingInputMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrainingInputMode
}
object TrainingInputMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrainingInputMode
  ): zio.aws.sagemaker.model.TrainingInputMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.PIPE =>
      val r = Pipe
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.FILE =>
      val r = File
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.FAST_FILE =>
      val r = FastFile
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrainingInputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingInputMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Pipe extends zio.aws.sagemaker.model.TrainingInputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingInputMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.PIPE
  }
  case object File extends zio.aws.sagemaker.model.TrainingInputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingInputMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.FILE
  }
  case object FastFile extends zio.aws.sagemaker.model.TrainingInputMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingInputMode =
      software.amazon.awssdk.services.sagemaker.model.TrainingInputMode.FAST_FILE
  }
}
