package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  HyperParameterValue,
  HyperParameterKey
}
import scala.jdk.CollectionConverters.*
final case class TrainingJobDefinition(
    trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode,
    hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]] =
      Optional.Absent,
    inputDataConfig: Iterable[zio.aws.sagemaker.model.Channel],
    outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig,
    resourceConfig: zio.aws.sagemaker.model.ResourceConfig,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition = {
    import TrainingJobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition
      .builder()
      .trainingInputMode(trainingInputMode.unwrap)
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .inputDataConfig(inputDataConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .resourceConfig(resourceConfig.buildAwsValue())
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly =
    zio.aws.sagemaker.model.TrainingJobDefinition.wrap(buildAwsValue())
}
object TrainingJobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJobDefinition =
      zio.aws.sagemaker.model.TrainingJobDefinition(
        trainingInputMode,
        hyperParameters.map(value => value),
        inputDataConfig.map { item =>
          item.asEditable
        },
        outputDataConfig.asEditable,
        resourceConfig.asEditable,
        stoppingCondition.asEditable
      )
    def trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode
    def hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]]
    def inputDataConfig: List[zio.aws.sagemaker.model.Channel.ReadOnly]
    def outputDataConfig: zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    def resourceConfig: zio.aws.sagemaker.model.ResourceConfig.ReadOnly
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def getTrainingInputMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInputMode] =
      ZIO.succeed(trainingInputMode)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getInputDataConfig
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getResourceConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      ZIO.succeed(resourceConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition
  ) extends zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly {
    override val trainingInputMode: zio.aws.sagemaker.model.TrainingInputMode =
      zio.aws.sagemaker.model.TrainingInputMode.wrap(impl.trainingInputMode())
    override val hyperParameters
        : Optional[Map[HyperParameterKey, HyperParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.HyperParameterKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
            })
            .toMap
        )
    override val inputDataConfig
        : List[zio.aws.sagemaker.model.Channel.ReadOnly] = impl
      .inputDataConfig()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.Channel.wrap(item)
      }
      .toList
    override val outputDataConfig
        : zio.aws.sagemaker.model.OutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val resourceConfig
        : zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
      zio.aws.sagemaker.model.ResourceConfig.wrap(impl.resourceConfig())
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobDefinition
  ): zio.aws.sagemaker.model.TrainingJobDefinition.ReadOnly = new Wrapper(impl)
}
