package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TransformJobStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TransformJobStatus
}
object TransformJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TransformJobStatus
  ): zio.aws.sagemaker.model.TransformJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.TransformJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TransformJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TransformJobStatus.STOPPED
  }
}
