package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, Accept, S3Uri}
import scala.jdk.CollectionConverters.*
final case class TransformOutput(
    s3OutputPath: S3Uri,
    accept: Optional[Accept] = Optional.Absent,
    assembleWith: Optional[zio.aws.sagemaker.model.AssemblyType] =
      Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformOutput = {
    import TransformOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformOutput
      .builder()
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .optionallyWith(
        accept.map(value => Accept.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(assembleWith.map(value => value.unwrap))(_.assembleWith)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformOutput.ReadOnly =
    zio.aws.sagemaker.model.TransformOutput.wrap(buildAwsValue())
}
object TransformOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformOutput =
      zio.aws.sagemaker.model.TransformOutput(
        s3OutputPath,
        accept.map(value => value),
        assembleWith.map(value => value),
        kmsKeyId.map(value => value)
      )
    def s3OutputPath: S3Uri
    def accept: Optional[Accept]
    def assembleWith: Optional[zio.aws.sagemaker.model.AssemblyType]
    def kmsKeyId: Optional[KmsKeyId]
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
    def getAccept: ZIO[Any, AwsError, Accept] =
      AwsError.unwrapOptionField("accept", accept)
    def getAssembleWith
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AssemblyType] =
      AwsError.unwrapOptionField("assembleWith", assembleWith)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformOutput
  ) extends zio.aws.sagemaker.model.TransformOutput.ReadOnly {
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
    override val accept: Optional[Accept] = zio.aws.core.internal
      .optionalFromNullable(impl.accept())
      .map(value => zio.aws.sagemaker.model.primitives.Accept(value))
    override val assembleWith: Optional[zio.aws.sagemaker.model.AssemblyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assembleWith())
        .map(value => zio.aws.sagemaker.model.AssemblyType.wrap(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformOutput
  ): zio.aws.sagemaker.model.TransformOutput.ReadOnly = new Wrapper(impl)
}
