package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrialArn,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Trial(
    trialName: Optional[ExperimentEntityName] = Optional.Absent,
    trialArn: Optional[TrialArn] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    experimentName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.TrialSource] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    trialComponentSummaries: Optional[
      Iterable[zio.aws.sagemaker.model.TrialComponentSimpleSummary]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Trial = {
    import Trial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Trial
      .builder()
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trialComponentSummaries)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Trial.ReadOnly =
    zio.aws.sagemaker.model.Trial.wrap(buildAwsValue())
}
object Trial {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Trial] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Trial =
      zio.aws.sagemaker.model.Trial(
        trialName.map(value => value),
        trialArn.map(value => value),
        displayName.map(value => value),
        experimentName.map(value => value),
        source.map(value => value.asEditable),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trialName: Optional[ExperimentEntityName]
    def trialArn: Optional[TrialArn]
    def displayName: Optional[ExperimentEntityName]
    def experimentName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.TrialSource.ReadOnly]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def trialComponentSummaries: Optional[
      List[zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly]
    ]
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTrialComponentSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trialComponentSummaries",
      trialComponentSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Trial
  ) extends zio.aws.sagemaker.model.Trial.ReadOnly {
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialArn: Optional[TrialArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.TrialSource.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val trialComponentSummaries: Optional[
      List[zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trialComponentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialComponentSimpleSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Trial
  ): zio.aws.sagemaker.model.Trial.ReadOnly = new Wrapper(impl)
}
