package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrialComponentPrimaryStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus
}
object TrialComponentPrimaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus
  ): zio.aws.sagemaker.model.TrialComponentPrimaryStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.COMPLETED
  }
  case object Failed
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.FAILED
  }
  case object Stopping
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.STOPPING
  }
  case object Stopped
      extends zio.aws.sagemaker.model.TrialComponentPrimaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus =
      software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus.STOPPED
  }
}
