package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TemplateContent
import scala.jdk.CollectionConverters.*
final case class UiTemplate(content: TemplateContent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UiTemplate = {
    import UiTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UiTemplate
      .builder()
      .content(TemplateContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UiTemplate.ReadOnly =
    zio.aws.sagemaker.model.UiTemplate.wrap(buildAwsValue())
}
object UiTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UiTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UiTemplate =
      zio.aws.sagemaker.model.UiTemplate(content)
    def content: TemplateContent
    def getContent: ZIO[Any, Nothing, TemplateContent] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UiTemplate
  ) extends zio.aws.sagemaker.model.UiTemplate.ReadOnly {
    override val content: TemplateContent =
      zio.aws.sagemaker.model.primitives.TemplateContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UiTemplate
  ): zio.aws.sagemaker.model.UiTemplate.ReadOnly = new Wrapper(impl)
}
