package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AppImageConfigArn
import scala.jdk.CollectionConverters.*
final case class UpdateAppImageConfigResponse(
    appImageConfigArn: Optional[AppImageConfigArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse = {
    import UpdateAppImageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse
      .builder()
      .optionallyWith(
        appImageConfigArn.map(value =>
          AppImageConfigArn.unwrap(value): java.lang.String
        )
      )(_.appImageConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateAppImageConfigResponse.wrap(buildAwsValue())
}
object UpdateAppImageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateAppImageConfigResponse =
      zio.aws.sagemaker.model
        .UpdateAppImageConfigResponse(appImageConfigArn.map(value => value))
    def appImageConfigArn: Optional[AppImageConfigArn]
    def getAppImageConfigArn: ZIO[Any, AwsError, AppImageConfigArn] =
      AwsError.unwrapOptionField("appImageConfigArn", appImageConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse
  ) extends zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly {
    override val appImageConfigArn: Optional[AppImageConfigArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appImageConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AppImageConfigArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse
  ): zio.aws.sagemaker.model.UpdateAppImageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
