package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentEntityName,
  ArtifactArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateArtifactRequest(
    artifactArn: ArtifactArn,
    artifactName: Optional[ExperimentEntityName] = Optional.Absent,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    propertiesToRemove: Optional[Iterable[StringParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest = {
    import UpdateArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest
      .builder()
      .artifactArn(ArtifactArn.unwrap(artifactArn): java.lang.String)
      .optionallyWith(
        artifactName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.artifactName)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue
                .unwrap(key): java.lang.String) -> (StringParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertiesToRemove.map(value =>
          value.map { item =>
            StringParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertiesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateArtifactRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateArtifactRequest.wrap(buildAwsValue())
}
object UpdateArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateArtifactRequest =
      zio.aws.sagemaker.model.UpdateArtifactRequest(
        artifactArn,
        artifactName.map(value => value),
        properties.map(value => value),
        propertiesToRemove.map(value => value)
      )
    def artifactArn: ArtifactArn
    def artifactName: Optional[ExperimentEntityName]
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def propertiesToRemove: Optional[List[StringParameterValue]]
    def getArtifactArn: ZIO[Any, Nothing, ArtifactArn] =
      ZIO.succeed(artifactArn)
    def getArtifactName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getPropertiesToRemove: ZIO[Any, AwsError, List[StringParameterValue]] =
      AwsError.unwrapOptionField("propertiesToRemove", propertiesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest
  ) extends zio.aws.sagemaker.model.UpdateArtifactRequest.ReadOnly {
    override val artifactArn: ArtifactArn =
      zio.aws.sagemaker.model.primitives.ArtifactArn(impl.artifactArn())
    override val artifactName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val propertiesToRemove: Optional[List[StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertiesToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest
  ): zio.aws.sagemaker.model.UpdateArtifactRequest.ReadOnly = new Wrapper(impl)
}
