package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentDescription,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class UpdateContextRequest(
    contextName: ExperimentEntityName,
    description: Optional[ExperimentDescription] = Optional.Absent,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    propertiesToRemove: Optional[Iterable[StringParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest = {
    import UpdateContextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
      .builder()
      .contextName(ExperimentEntityName.unwrap(contextName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue
                .unwrap(key): java.lang.String) -> (StringParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertiesToRemove.map(value =>
          value.map { item =>
            StringParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertiesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateContextRequest.wrap(buildAwsValue())
}
object UpdateContextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateContextRequest =
      zio.aws.sagemaker.model.UpdateContextRequest(
        contextName,
        description.map(value => value),
        properties.map(value => value),
        propertiesToRemove.map(value => value)
      )
    def contextName: ExperimentEntityName
    def description: Optional[ExperimentDescription]
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def propertiesToRemove: Optional[List[StringParameterValue]]
    def getContextName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(contextName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getPropertiesToRemove: ZIO[Any, AwsError, List[StringParameterValue]] =
      AwsError.unwrapOptionField("propertiesToRemove", propertiesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ) extends zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly {
    override val contextName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.contextName())
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val propertiesToRemove: Optional[List[StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertiesToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.StringParameterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest
  ): zio.aws.sagemaker.model.UpdateContextRequest.ReadOnly = new Wrapper(impl)
}
