package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ExperimentDescription,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class UpdateExperimentRequest(
    experimentName: ExperimentEntityName,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    description: Optional[ExperimentDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest = {
    import UpdateExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest
      .builder()
      .experimentName(
        ExperimentEntityName.unwrap(experimentName): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateExperimentRequest.wrap(buildAwsValue())
}
object UpdateExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateExperimentRequest =
      zio.aws.sagemaker.model.UpdateExperimentRequest(
        experimentName,
        displayName.map(value => value),
        description.map(value => value)
      )
    def experimentName: ExperimentEntityName
    def displayName: Optional[ExperimentEntityName]
    def description: Optional[ExperimentDescription]
    def getExperimentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(experimentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest
  ) extends zio.aws.sagemaker.model.UpdateExperimentRequest.ReadOnly {
    override val experimentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.experimentName())
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest
  ): zio.aws.sagemaker.model.UpdateExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
