package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrialComponentKey64,
  TrialComponentKey256,
  Timestamp,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateTrialComponentRequest(
    trialComponentName: ExperimentEntityName,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.TrialComponentStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue
    ]] = Optional.Absent,
    parametersToRemove: Optional[Iterable[TrialComponentKey256]] =
      Optional.Absent,
    inputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    inputArtifactsToRemove: Optional[Iterable[TrialComponentKey256]] =
      Optional.Absent,
    outputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    outputArtifactsToRemove: Optional[Iterable[TrialComponentKey256]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest = {
    import UpdateTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        parametersToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parametersToRemove)
      .optionallyWith(
        inputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputArtifacts)
      .optionallyWith(
        inputArtifactsToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inputArtifactsToRemove)
      .optionallyWith(
        outputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.outputArtifacts)
      .optionallyWith(
        outputArtifactsToRemove.map(value =>
          value.map { item =>
            TrialComponentKey256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputArtifactsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrialComponentRequest.wrap(buildAwsValue())
}
object UpdateTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrialComponentRequest =
      zio.aws.sagemaker.model.UpdateTrialComponentRequest(
        trialComponentName,
        displayName.map(value => value),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        parametersToRemove.map(value => value),
        inputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        inputArtifactsToRemove.map(value => value),
        outputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        outputArtifactsToRemove.map(value => value)
      )
    def trialComponentName: ExperimentEntityName
    def displayName: Optional[ExperimentEntityName]
    def status: Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]]
    def parametersToRemove: Optional[List[TrialComponentKey256]]
    def inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def inputArtifactsToRemove: Optional[List[TrialComponentKey256]]
    def outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def outputArtifactsToRemove: Optional[List[TrialComponentKey256]]
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getParameters: ZIO[Any, AwsError, Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getParametersToRemove: ZIO[Any, AwsError, List[TrialComponentKey256]] =
      AwsError.unwrapOptionField("parametersToRemove", parametersToRemove)
    def getInputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getInputArtifactsToRemove
        : ZIO[Any, AwsError, List[TrialComponentKey256]] = AwsError
      .unwrapOptionField("inputArtifactsToRemove", inputArtifactsToRemove)
    def getOutputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getOutputArtifactsToRemove
        : ZIO[Any, AwsError, List[TrialComponentKey256]] = AwsError
      .unwrapOptionField("outputArtifactsToRemove", outputArtifactsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ) extends zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val status
        : Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val parametersToRemove: Optional[List[TrialComponentKey256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parametersToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
          }.toList
        )
    override val inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val inputArtifactsToRemove: Optional[List[TrialComponentKey256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputArtifactsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
          }.toList
        )
    override val outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val outputArtifactsToRemove: Optional[List[TrialComponentKey256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputArtifactsToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest
  ): zio.aws.sagemaker.model.UpdateTrialComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
