package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait VariantPropertyType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.VariantPropertyType
}
object VariantPropertyType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.VariantPropertyType
  ): zio.aws.sagemaker.model.VariantPropertyType = value match {
    case software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DESIRED_INSTANCE_COUNT =>
      val r = DesiredInstanceCount
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DESIRED_WEIGHT =>
      val r = DesiredWeight
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DATA_CAPTURE_CONFIG =>
      val r = DataCaptureConfig
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.VariantPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantPropertyType =
      software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.UNKNOWN_TO_SDK_VERSION
  }
  case object DesiredInstanceCount
      extends zio.aws.sagemaker.model.VariantPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantPropertyType =
      software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DESIRED_INSTANCE_COUNT
  }
  case object DesiredWeight
      extends zio.aws.sagemaker.model.VariantPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantPropertyType =
      software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DESIRED_WEIGHT
  }
  case object DataCaptureConfig
      extends zio.aws.sagemaker.model.VariantPropertyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantPropertyType =
      software.amazon.awssdk.services.sagemaker.model.VariantPropertyType.DATA_CAPTURE_CONFIG
  }
}
