package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrainingJobName,
  ResourceRetainedBillableTimeInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WarmPoolStatus(
    status: zio.aws.sagemaker.model.WarmPoolResourceStatus,
    resourceRetainedBillableTimeInSeconds: Optional[
      ResourceRetainedBillableTimeInSeconds
    ] = Optional.Absent,
    reusedByJob: Optional[TrainingJobName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus = {
    import WarmPoolStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        resourceRetainedBillableTimeInSeconds.map(value =>
          ResourceRetainedBillableTimeInSeconds.unwrap(value): Integer
        )
      )(_.resourceRetainedBillableTimeInSeconds)
      .optionallyWith(
        reusedByJob.map(value =>
          TrainingJobName.unwrap(value): java.lang.String
        )
      )(_.reusedByJob)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly =
    zio.aws.sagemaker.model.WarmPoolStatus.wrap(buildAwsValue())
}
object WarmPoolStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.WarmPoolStatus =
      zio.aws.sagemaker.model.WarmPoolStatus(
        status,
        resourceRetainedBillableTimeInSeconds.map(value => value),
        reusedByJob.map(value => value)
      )
    def status: zio.aws.sagemaker.model.WarmPoolResourceStatus
    def resourceRetainedBillableTimeInSeconds
        : Optional[ResourceRetainedBillableTimeInSeconds]
    def reusedByJob: Optional[TrainingJobName]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.WarmPoolResourceStatus] =
      ZIO.succeed(status)
    def getResourceRetainedBillableTimeInSeconds
        : ZIO[Any, AwsError, ResourceRetainedBillableTimeInSeconds] =
      AwsError.unwrapOptionField(
        "resourceRetainedBillableTimeInSeconds",
        resourceRetainedBillableTimeInSeconds
      )
    def getReusedByJob: ZIO[Any, AwsError, TrainingJobName] =
      AwsError.unwrapOptionField("reusedByJob", reusedByJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus
  ) extends zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly {
    override val status: zio.aws.sagemaker.model.WarmPoolResourceStatus =
      zio.aws.sagemaker.model.WarmPoolResourceStatus.wrap(impl.status())
    override val resourceRetainedBillableTimeInSeconds
        : Optional[ResourceRetainedBillableTimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRetainedBillableTimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .ResourceRetainedBillableTimeInSeconds(value)
        )
    override val reusedByJob: Optional[TrainingJobName] = zio.aws.core.internal
      .optionalFromNullable(impl.reusedByJob())
      .map(value => zio.aws.sagemaker.model.primitives.TrainingJobName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus
  ): zio.aws.sagemaker.model.WarmPoolStatus.ReadOnly = new Wrapper(impl)
}
