package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  WorkforceFailureReason,
  Timestamp,
  WorkforceArn,
  WorkforceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Workforce(
    workforceName: WorkforceName,
    workforceArn: WorkforceArn,
    lastUpdatedDate: Optional[Timestamp] = Optional.Absent,
    sourceIpConfig: Optional[zio.aws.sagemaker.model.SourceIpConfig] =
      Optional.Absent,
    subDomain: Optional[String] = Optional.Absent,
    cognitoConfig: Optional[zio.aws.sagemaker.model.CognitoConfig] =
      Optional.Absent,
    oidcConfig: Optional[zio.aws.sagemaker.model.OidcConfigForResponse] =
      Optional.Absent,
    createDate: Optional[Timestamp] = Optional.Absent,
    workforceVpcConfig: Optional[
      zio.aws.sagemaker.model.WorkforceVpcConfigResponse
    ] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.WorkforceStatus] = Optional.Absent,
    failureReason: Optional[WorkforceFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Workforce = {
    import Workforce.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Workforce
      .builder()
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .workforceArn(WorkforceArn.unwrap(workforceArn): java.lang.String)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .optionallyWith(sourceIpConfig.map(value => value.buildAwsValue()))(
        _.sourceIpConfig
      )
      .optionallyWith(subDomain.map(value => value: java.lang.String))(
        _.subDomain
      )
      .optionallyWith(cognitoConfig.map(value => value.buildAwsValue()))(
        _.cognitoConfig
      )
      .optionallyWith(oidcConfig.map(value => value.buildAwsValue()))(
        _.oidcConfig
      )
      .optionallyWith(
        createDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(workforceVpcConfig.map(value => value.buildAwsValue()))(
        _.workforceVpcConfig
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failureReason.map(value =>
          WorkforceFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Workforce.ReadOnly =
    zio.aws.sagemaker.model.Workforce.wrap(buildAwsValue())
}
object Workforce {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Workforce
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Workforce =
      zio.aws.sagemaker.model.Workforce(
        workforceName,
        workforceArn,
        lastUpdatedDate.map(value => value),
        sourceIpConfig.map(value => value.asEditable),
        subDomain.map(value => value),
        cognitoConfig.map(value => value.asEditable),
        oidcConfig.map(value => value.asEditable),
        createDate.map(value => value),
        workforceVpcConfig.map(value => value.asEditable),
        status.map(value => value),
        failureReason.map(value => value)
      )
    def workforceName: WorkforceName
    def workforceArn: WorkforceArn
    def lastUpdatedDate: Optional[Timestamp]
    def sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly]
    def subDomain: Optional[String]
    def cognitoConfig: Optional[zio.aws.sagemaker.model.CognitoConfig.ReadOnly]
    def oidcConfig
        : Optional[zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly]
    def createDate: Optional[Timestamp]
    def workforceVpcConfig
        : Optional[zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly]
    def status: Optional[zio.aws.sagemaker.model.WorkforceStatus]
    def failureReason: Optional[WorkforceFailureReason]
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
    def getWorkforceArn: ZIO[Any, Nothing, WorkforceArn] =
      ZIO.succeed(workforceArn)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getSourceIpConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      AwsError.unwrapOptionField("sourceIpConfig", sourceIpConfig)
    def getSubDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subDomain", subDomain)
    def getCognitoConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CognitoConfig.ReadOnly] =
      AwsError.unwrapOptionField("cognitoConfig", cognitoConfig)
    def getOidcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly
    ] = AwsError.unwrapOptionField("oidcConfig", oidcConfig)
    def getCreateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getWorkforceVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("workforceVpcConfig", workforceVpcConfig)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.WorkforceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, WorkforceFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Workforce
  ) extends zio.aws.sagemaker.model.Workforce.ReadOnly {
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
    override val workforceArn: WorkforceArn =
      zio.aws.sagemaker.model.primitives.WorkforceArn(impl.workforceArn())
    override val lastUpdatedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIpConfig())
        .map(value => zio.aws.sagemaker.model.SourceIpConfig.wrap(value))
    override val subDomain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subDomain())
      .map(value => value: String)
    override val cognitoConfig
        : Optional[zio.aws.sagemaker.model.CognitoConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoConfig())
        .map(value => zio.aws.sagemaker.model.CognitoConfig.wrap(value))
    override val oidcConfig
        : Optional[zio.aws.sagemaker.model.OidcConfigForResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oidcConfig())
        .map(value => zio.aws.sagemaker.model.OidcConfigForResponse.wrap(value))
    override val createDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val workforceVpcConfig: Optional[
      zio.aws.sagemaker.model.WorkforceVpcConfigResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workforceVpcConfig())
      .map(value =>
        zio.aws.sagemaker.model.WorkforceVpcConfigResponse.wrap(value)
      )
    override val status: Optional[zio.aws.sagemaker.model.WorkforceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.WorkforceStatus.wrap(value))
    override val failureReason: Optional[WorkforceFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives.WorkforceFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Workforce
  ): zio.aws.sagemaker.model.Workforce.ReadOnly = new Wrapper(impl)
}
