package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  WorkforceSubnetId,
  WorkforceSecurityGroupId,
  WorkforceVpcId
}
import scala.jdk.CollectionConverters.*
final case class WorkforceVpcConfigRequest(
    vpcId: Optional[WorkforceVpcId] = Optional.Absent,
    securityGroupIds: Optional[Iterable[WorkforceSecurityGroupId]] =
      Optional.Absent,
    subnets: Optional[Iterable[WorkforceSubnetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest = {
    import WorkforceVpcConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest
      .builder()
      .optionallyWith(
        vpcId.map(value => WorkforceVpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            WorkforceSecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            WorkforceSubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.WorkforceVpcConfigRequest.wrap(buildAwsValue())
}
object WorkforceVpcConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.WorkforceVpcConfigRequest =
      zio.aws.sagemaker.model.WorkforceVpcConfigRequest(
        vpcId.map(value => value),
        securityGroupIds.map(value => value),
        subnets.map(value => value)
      )
    def vpcId: Optional[WorkforceVpcId]
    def securityGroupIds: Optional[List[WorkforceSecurityGroupId]]
    def subnets: Optional[List[WorkforceSubnetId]]
    def getVpcId: ZIO[Any, AwsError, WorkforceVpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSecurityGroupIds
        : ZIO[Any, AwsError, List[WorkforceSecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnets: ZIO[Any, AwsError, List[WorkforceSubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest
  ) extends zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly {
    override val vpcId: Optional[WorkforceVpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.sagemaker.model.primitives.WorkforceVpcId(value))
    override val securityGroupIds: Optional[List[WorkforceSecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.WorkforceSecurityGroupId(item)
          }.toList
        )
    override val subnets: Optional[List[WorkforceSubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.WorkforceSubnetId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.WorkforceVpcConfigRequest
  ): zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
