package zio.aws.savingsplans
import zio.aws.savingsplans.model.DeleteQueuedSavingsPlanResponse.ReadOnly
import software.amazon.awssdk.services.savingsplans.{
  SavingsplansAsyncClientBuilder,
  SavingsplansAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.savingsplans.model.{
  DescribeSavingsPlansOfferingsRequest,
  ListTagsForResourceRequest,
  DescribeSavingsPlanRatesRequest,
  CreateSavingsPlanRequest,
  DeleteQueuedSavingsPlanRequest,
  UntagResourceRequest,
  DescribeSavingsPlansOfferingRatesRequest,
  TagResourceRequest,
  DescribeSavingsPlansRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.savingsplans.model.{
  DescribeSavingsPlansOfferingsResponse,
  DescribeSavingsPlansOfferingRatesResponse,
  CreateSavingsPlanResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeSavingsPlanRatesResponse,
  DescribeSavingsPlansResponse,
  TagResourceResponse,
  DeleteQueuedSavingsPlanResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters.*
trait Savingsplans extends AspectSupport[Savingsplans] {
  val api: SavingsplansAsyncClient
  def deleteQueuedSavingsPlan(
      request: DeleteQueuedSavingsPlanRequest
  ): IO[AwsError, ReadOnly]
  def describeSavingsPlansOfferings(
      request: DescribeSavingsPlansOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
  ]
  def describeSavingsPlans(request: DescribeSavingsPlansRequest): IO[
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
  ]
  def createSavingsPlan(
      request: CreateSavingsPlanRequest
  ): IO[AwsError, zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.savingsplans.model.UntagResourceResponse.ReadOnly]
  def describeSavingsPlansOfferingRates(
      request: DescribeSavingsPlansOfferingRatesRequest
  ): IO[
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
  ]
  def describeSavingsPlanRates(request: DescribeSavingsPlanRatesRequest): IO[
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.savingsplans.model.TagResourceResponse.ReadOnly]
}
object Savingsplans {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Savingsplans] = customized(
    identity
  )
  def customized(
      customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Savingsplans] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SavingsplansAsyncClientBuilder => SavingsplansAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Savingsplans] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SavingsplansAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SavingsplansAsyncClient, SavingsplansAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SavingsplansAsyncClient,
      SavingsplansAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SavingsplansImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SavingsplansImpl[R](
      override val api: SavingsplansAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Savingsplans
      with AwsServiceBase[R] {
    override val serviceName: String = "Savingsplans"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SavingsplansImpl[R1] = new SavingsplansImpl(api, newAspect, r)
    def deleteQueuedSavingsPlan(
        request: DeleteQueuedSavingsPlanRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest,
      DeleteQueuedSavingsPlanResponse
    ]("deleteQueuedSavingsPlan", api.deleteQueuedSavingsPlan)(
      request.buildAwsValue()
    ).map(zio.aws.savingsplans.model.DeleteQueuedSavingsPlanResponse.wrap)
      .provideEnvironment(r)
    def describeSavingsPlansOfferings(
        request: DescribeSavingsPlansOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest,
      DescribeSavingsPlansOfferingsResponse
    ]("describeSavingsPlansOfferings", api.describeSavingsPlansOfferings)(
      request.buildAwsValue()
    ).map(zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.wrap)
      .provideEnvironment(r)
    def describeSavingsPlans(request: DescribeSavingsPlansRequest): IO[
      AwsError,
      zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest,
      DescribeSavingsPlansResponse
    ]("describeSavingsPlans", api.describeSavingsPlans)(request.buildAwsValue())
      .map(zio.aws.savingsplans.model.DescribeSavingsPlansResponse.wrap)
      .provideEnvironment(r)
    def createSavingsPlan(request: CreateSavingsPlanRequest): IO[
      AwsError,
      zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest,
      CreateSavingsPlanResponse
    ]("createSavingsPlan", api.createSavingsPlan)(request.buildAwsValue())
      .map(zio.aws.savingsplans.model.CreateSavingsPlanResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.savingsplans.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.savingsplans.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeSavingsPlansOfferingRates(
        request: DescribeSavingsPlansOfferingRatesRequest
    ): IO[
      AwsError,
      zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest,
      DescribeSavingsPlansOfferingRatesResponse
    ](
      "describeSavingsPlansOfferingRates",
      api.describeSavingsPlansOfferingRates
    )(request.buildAwsValue())
      .map(
        zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.savingsplans.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeSavingsPlanRates(request: DescribeSavingsPlanRatesRequest): IO[
      AwsError,
      zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest,
      DescribeSavingsPlanRatesResponse
    ]("describeSavingsPlanRates", api.describeSavingsPlanRates)(
      request.buildAwsValue()
    ).map(zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.savingsplans.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.savingsplans.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.savingsplans.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteQueuedSavingsPlan(
      request: DeleteQueuedSavingsPlanRequest
  ): ZIO[zio.aws.savingsplans.Savingsplans, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteQueuedSavingsPlan(request))
  def describeSavingsPlansOfferings(
      request: DescribeSavingsPlansOfferingsRequest
  ): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSavingsPlansOfferings(request))
  def describeSavingsPlans(request: DescribeSavingsPlansRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSavingsPlans(request))
  def createSavingsPlan(request: CreateSavingsPlanRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSavingsPlan(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeSavingsPlansOfferingRates(
      request: DescribeSavingsPlansOfferingRatesRequest
  ): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSavingsPlansOfferingRates(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeSavingsPlanRates(request: DescribeSavingsPlanRatesRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSavingsPlanRates(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.savingsplans.Savingsplans,
    AwsError,
    zio.aws.savingsplans.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
}
