package zio.aws.savingsplans
import zio.aws.savingsplans.model.DeleteQueuedSavingsPlanResponse.ReadOnly
import software.amazon.awssdk.services.savingsplans.SavingsplansAsyncClient
import zio.aws.savingsplans.model.{
  DescribeSavingsPlansOfferingsRequest,
  ListTagsForResourceRequest,
  DescribeSavingsPlanRatesRequest,
  CreateSavingsPlanRequest,
  DeleteQueuedSavingsPlanRequest,
  UntagResourceRequest,
  DescribeSavingsPlansOfferingRatesRequest,
  TagResourceRequest,
  DescribeSavingsPlansRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object SavingsplansMock extends Mock[Savingsplans] {
  object DeleteQueuedSavingsPlan
      extends Effect[DeleteQueuedSavingsPlanRequest, AwsError, ReadOnly]
  object DescribeSavingsPlansOfferings
      extends Effect[
        DescribeSavingsPlansOfferingsRequest,
        AwsError,
        zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
      ]
  object DescribeSavingsPlans
      extends Effect[
        DescribeSavingsPlansRequest,
        AwsError,
        zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
      ]
  object CreateSavingsPlan
      extends Effect[
        CreateSavingsPlanRequest,
        AwsError,
        zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.savingsplans.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeSavingsPlansOfferingRates
      extends Effect[
        DescribeSavingsPlansOfferingRatesRequest,
        AwsError,
        zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeSavingsPlanRates
      extends Effect[
        DescribeSavingsPlanRatesRequest,
        AwsError,
        zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.savingsplans.model.TagResourceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Savingsplans] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Savingsplans] { rts =>
        zio.ZIO.succeed {
          new Savingsplans {
            val api: SavingsplansAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Savingsplans = this
            def deleteQueuedSavingsPlan(
                request: DeleteQueuedSavingsPlanRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteQueuedSavingsPlan, request)
            def describeSavingsPlansOfferings(
                request: DescribeSavingsPlansOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.savingsplans.model.DescribeSavingsPlansOfferingsResponse.ReadOnly
            ] = proxy(DescribeSavingsPlansOfferings, request)
            def describeSavingsPlans(request: DescribeSavingsPlansRequest): IO[
              AwsError,
              zio.aws.savingsplans.model.DescribeSavingsPlansResponse.ReadOnly
            ] = proxy(DescribeSavingsPlans, request)
            def createSavingsPlan(request: CreateSavingsPlanRequest): IO[
              AwsError,
              zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly
            ] = proxy(CreateSavingsPlan, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.savingsplans.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeSavingsPlansOfferingRates(
                request: DescribeSavingsPlansOfferingRatesRequest
            ): IO[
              AwsError,
              zio.aws.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse.ReadOnly
            ] = proxy(DescribeSavingsPlansOfferingRates, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.savingsplans.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeSavingsPlanRates(
                request: DescribeSavingsPlanRatesRequest
            ): IO[
              AwsError,
              zio.aws.savingsplans.model.DescribeSavingsPlanRatesResponse.ReadOnly
            ] = proxy(DescribeSavingsPlanRates, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.savingsplans.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
          }
        }
      }
    }
  }
}
