package zio.aws.savingsplans.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.savingsplans.model.primitives.{
  TagValue,
  DateTime,
  Amount,
  SavingsPlanOfferingId,
  ClientToken,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateSavingsPlanRequest(
    savingsPlanOfferingId: SavingsPlanOfferingId,
    commitment: Amount,
    upfrontPaymentAmount: Optional[Amount] = Optional.Absent,
    purchaseTime: Optional[DateTime] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest = {
    import CreateSavingsPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
      .builder()
      .savingsPlanOfferingId(
        SavingsPlanOfferingId.unwrap(savingsPlanOfferingId): java.lang.String
      )
      .commitment(Amount.unwrap(commitment): java.lang.String)
      .optionallyWith(
        upfrontPaymentAmount.map(value =>
          Amount.unwrap(value): java.lang.String
        )
      )(_.upfrontPaymentAmount)
      .optionallyWith(
        purchaseTime.map(value => DateTime.unwrap(value): Instant)
      )(_.purchaseTime)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly =
    zio.aws.savingsplans.model.CreateSavingsPlanRequest.wrap(buildAwsValue())
}
object CreateSavingsPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.CreateSavingsPlanRequest =
      zio.aws.savingsplans.model.CreateSavingsPlanRequest(
        savingsPlanOfferingId,
        commitment,
        upfrontPaymentAmount.map(value => value),
        purchaseTime.map(value => value),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def savingsPlanOfferingId: SavingsPlanOfferingId
    def commitment: Amount
    def upfrontPaymentAmount: Optional[Amount]
    def purchaseTime: Optional[DateTime]
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getSavingsPlanOfferingId: ZIO[Any, Nothing, SavingsPlanOfferingId] =
      ZIO.succeed(savingsPlanOfferingId)
    def getCommitment: ZIO[Any, Nothing, Amount] = ZIO.succeed(commitment)
    def getUpfrontPaymentAmount: ZIO[Any, AwsError, Amount] =
      AwsError.unwrapOptionField("upfrontPaymentAmount", upfrontPaymentAmount)
    def getPurchaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("purchaseTime", purchaseTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ) extends zio.aws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly {
    override val savingsPlanOfferingId: SavingsPlanOfferingId =
      zio.aws.savingsplans.model.primitives
        .SavingsPlanOfferingId(impl.savingsPlanOfferingId())
    override val commitment: Amount =
      zio.aws.savingsplans.model.primitives.Amount(impl.commitment())
    override val upfrontPaymentAmount: Optional[Amount] = zio.aws.core.internal
      .optionalFromNullable(impl.upfrontPaymentAmount())
      .map(value => zio.aws.savingsplans.model.primitives.Amount(value))
    override val purchaseTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.purchaseTime())
      .map(value => zio.aws.savingsplans.model.primitives.DateTime(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.savingsplans.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.savingsplans.model.primitives.TagKey(
              key
            ) -> zio.aws.savingsplans.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest
  ): zio.aws.savingsplans.model.CreateSavingsPlanRequest.ReadOnly = new Wrapper(
    impl
  )
}
