package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.SavingsPlanId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSavingsPlanResponse(
    savingsPlanId: Optional[SavingsPlanId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse = {
    import CreateSavingsPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
      .builder()
      .optionallyWith(
        savingsPlanId.map(value =>
          SavingsPlanId.unwrap(value): java.lang.String
        )
      )(_.savingsPlanId)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly =
    zio.aws.savingsplans.model.CreateSavingsPlanResponse.wrap(buildAwsValue())
}
object CreateSavingsPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.CreateSavingsPlanResponse =
      zio.aws.savingsplans.model
        .CreateSavingsPlanResponse(savingsPlanId.map(value => value))
    def savingsPlanId: Optional[SavingsPlanId]
    def getSavingsPlanId: ZIO[Any, AwsError, SavingsPlanId] =
      AwsError.unwrapOptionField("savingsPlanId", savingsPlanId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ) extends zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly {
    override val savingsPlanId: Optional[SavingsPlanId] = zio.aws.core.internal
      .optionalFromNullable(impl.savingsPlanId())
      .map(value => zio.aws.savingsplans.model.primitives.SavingsPlanId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse
  ): zio.aws.savingsplans.model.CreateSavingsPlanResponse.ReadOnly =
    new Wrapper(impl)
}
