package zio.aws.savingsplans.model
import scala.jdk.CollectionConverters.*
sealed trait CurrencyCode {
  def unwrap: software.amazon.awssdk.services.savingsplans.model.CurrencyCode
}
object CurrencyCode {
  def wrap(
      value: software.amazon.awssdk.services.savingsplans.model.CurrencyCode
  ): zio.aws.savingsplans.model.CurrencyCode = value match {
    case software.amazon.awssdk.services.savingsplans.model.CurrencyCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.CurrencyCode.CNY =>
      val r = CNY
      r
    case software.amazon.awssdk.services.savingsplans.model.CurrencyCode.USD =>
      val r = USD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.savingsplans.model.CurrencyCode {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.CurrencyCode =
      software.amazon.awssdk.services.savingsplans.model.CurrencyCode.UNKNOWN_TO_SDK_VERSION
  }
  case object CNY extends zio.aws.savingsplans.model.CurrencyCode {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.CurrencyCode =
      software.amazon.awssdk.services.savingsplans.model.CurrencyCode.CNY
  }
  case object USD extends zio.aws.savingsplans.model.CurrencyCode {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.CurrencyCode =
      software.amazon.awssdk.services.savingsplans.model.CurrencyCode.USD
  }
}
