package zio.aws.savingsplans.model
import zio.ZIO
import zio.aws.savingsplans.model.primitives.SavingsPlanId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteQueuedSavingsPlanRequest(savingsPlanId: SavingsPlanId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest = {
    import DeleteQueuedSavingsPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest
      .builder()
      .savingsPlanId(SavingsPlanId.unwrap(savingsPlanId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest.ReadOnly =
    zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest
      .wrap(buildAwsValue())
}
object DeleteQueuedSavingsPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest =
      zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest(savingsPlanId)
    def savingsPlanId: SavingsPlanId
    def getSavingsPlanId: ZIO[Any, Nothing, SavingsPlanId] =
      ZIO.succeed(savingsPlanId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest
  ) extends zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest.ReadOnly {
    override val savingsPlanId: SavingsPlanId =
      zio.aws.savingsplans.model.primitives.SavingsPlanId(impl.savingsPlanId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest
  ): zio.aws.savingsplans.model.DeleteQueuedSavingsPlanRequest.ReadOnly =
    new Wrapper(impl)
}
