package zio.aws.savingsplans.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.savingsplans.model.primitives.{
  MaxResults,
  PaginationToken,
  SavingsPlanId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlanRatesRequest(
    savingsPlanId: SavingsPlanId,
    filters: Optional[
      Iterable[zio.aws.savingsplans.model.SavingsPlanRateFilter]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest = {
    import DescribeSavingsPlanRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
      .builder()
      .savingsPlanId(SavingsPlanId.unwrap(savingsPlanId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly =
    zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest =
      zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest(
        savingsPlanId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def savingsPlanId: SavingsPlanId
    def filters: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getSavingsPlanId: ZIO[Any, Nothing, SavingsPlanId] =
      ZIO.succeed(savingsPlanId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ) extends zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly {
    override val savingsPlanId: SavingsPlanId =
      zio.aws.savingsplans.model.primitives.SavingsPlanId(impl.savingsPlanId())
    override val filters: Optional[
      List[zio.aws.savingsplans.model.SavingsPlanRateFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.savingsplans.model.SavingsPlanRateFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.savingsplans.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.savingsplans.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ): zio.aws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly =
    new Wrapper(impl)
}
